//
//  MCReportModelBrowserController.h
//  ReportBuilder
//
//  Created by Alykhan Jetha on 01/05/05.
//  Copyright 2005 Marketcircle Inc.. All rights reserved.
//

#import "MCReportAbstractArrayEditor.h"

@class MCReportModelBrowser;

@interface MCReportModelBrowserController : MCReportAbstractArrayEditor {
	IBOutlet MCReportModelBrowser *browser;
	
	NSString *lastKeyPath;
	NSString *lastRelativePrefix;
	id lastRepresentedObject;
	
	IBOutlet NSTextField *resultingField;
	IBOutlet NSTextField *resultKindField;
	IBOutlet NSTextField *existingPathField;
	
	IBOutlet NSButton *okButton;
	
	int mode;  // 0 == array, 1 == attribute

}

- (void)workInArrayMode;
- (void)workInAttributeMode;


- (NSString *)lastKeyPath;
- (void)setLastKeyPath:(NSString *)aLastKeyPath;

- (NSString *)lastRelativePrefix;
- (void)setLastRelativePrefix:(NSString *)aLastRelativePrefix;

- (id)lastRepresentedObject;
- (void)setLastRepresentedObject:(id)aLastRepresentedObject;



@end

@interface NSObject (MCReportModelBrowserControllerDelegate)

// informs the delegate of the users selection

- (void)reportModelBrowser:(MCReportModelBrowserController *)aBrowser finalizedSelectedWithKeyPath:(NSString *)aKeypath destinationEntityName:(NSString *)anEntityName type:(int)aType;

@end

